/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core.okio;

import androidx.datastore.core.InterProcessCoordinator;
import androidx.datastore.core.Storage;
import androidx.datastore.core.StorageConnection;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.core.okio.OkioStorageConnection;
import androidx.datastore.core.okio.Synchronizer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0015BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016R\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/datastore/core/okio/OkioStorage;", "T", "Landroidx/datastore/core/Storage;", "fileSystem", "Lokio/FileSystem;", "serializer", "Landroidx/datastore/core/okio/OkioSerializer;", "coordinatorProducer", "Lkotlin/Function2;", "Lokio/Path;", "Landroidx/datastore/core/InterProcessCoordinator;", "producePath", "Lkotlin/Function0;", "(Lokio/FileSystem;Landroidx/datastore/core/okio/OkioSerializer;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "canonicalPath", "getCanonicalPath", "()Lokio/Path;", "canonicalPath$delegate", "Lkotlin/Lazy;", "createConnection", "Landroidx/datastore/core/StorageConnection;", "Companion", "datastore-core-okio"})
@SourceDebugExtension(value={"SMAP\nOkioStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkioStorage.kt\nandroidx/datastore/core/okio/OkioStorage\n+ 2 Atomic.jvm.kt\nandroidx/datastore/core/okio/Synchronizer\n*L\n1#1,230:1\n49#2,2:231\n*S KotlinDebug\n*F\n+ 1 OkioStorage.kt\nandroidx/datastore/core/okio/OkioStorage\n*L\n64#1:231,2\n*E\n"})
public final class OkioStorage<T>
implements Storage<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final OkioSerializer<T> serializer;
    @NotNull
    private final Function2<Path, FileSystem, InterProcessCoordinator> coordinatorProducer;
    @NotNull
    private final Function0<Path> producePath;
    @NotNull
    private final Lazy canonicalPath$delegate;
    @NotNull
    private static final Set<String> activeFiles = new LinkedHashSet();
    @NotNull
    private static final Synchronizer activeFilesLock = new Synchronizer();

    public OkioStorage(@NotNull FileSystem fileSystem, @NotNull OkioSerializer<T> serializer, @NotNull Function2<? super Path, ? super FileSystem, ? extends InterProcessCoordinator> coordinatorProducer, @NotNull Function0<Path> producePath) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(coordinatorProducer, (String)"coordinatorProducer");
        Intrinsics.checkNotNullParameter(producePath, (String)"producePath");
        this.fileSystem = fileSystem;
        this.serializer = serializer;
        this.coordinatorProducer = coordinatorProducer;
        this.producePath = producePath;
        this.canonicalPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ OkioStorage<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = (Path)OkioStorage.access$getProducePath$p(this.this$0).invoke();
                boolean bl = path.isAbsolute();
                OkioStorage<T> okioStorage = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "OkioStorage requires absolute paths, but did not get an absolute path from producePath = " + OkioStorage.access$getProducePath$p(okioStorage) + ", instead got " + path;
                    throw new IllegalStateException(string.toString());
                }
                return path.normalized();
            }
        }));
    }

    public /* synthetic */ OkioStorage(FileSystem fileSystem, OkioSerializer okioSerializer, Function2 function2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(fileSystem, okioSerializer, (Function2<? super Path, ? super FileSystem, ? extends InterProcessCoordinator>)function2, (Function0<Path>)function0);
    }

    private final Path getCanonicalPath() {
        Lazy lazy = this.canonicalPath$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StorageConnection<T> createConnection() {
        String path = this.getCanonicalPath().toString();
        boolean bl = false;
        Synchronizer this_$iv = activeFilesLock;
        boolean $i$f$withLock = false;
        Synchronizer synchronizer = this_$iv;
        synchronized (synchronizer) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (!(!activeFiles.contains(path))) {
                boolean bl4 = false;
                String string = "There are multiple DataStores active for the same file: " + path + ". You should either maintain your DataStore as a singleton or confirm that there is no two DataStore's active on the same file (by confirming that the scope is cancelled).";
                throw new IllegalStateException(string.toString());
            }
            boolean bl5 = activeFiles.add(path);
        }
        return new OkioStorageConnection<T>(this.fileSystem, this.getCanonicalPath(), this.serializer, (InterProcessCoordinator)this.coordinatorProducer.invoke((Object)this.getCanonicalPath(), (Object)this.fileSystem), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ OkioStorage<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void this_$iv;
                Synchronizer synchronizer = OkioStorage.Companion.getActiveFilesLock();
                OkioStorage<T> okioStorage = this.this$0;
                boolean $i$f$withLock = false;
                void var4_4 = this_$iv;
                synchronized (var4_4) {
                    boolean bl = false;
                    boolean bl2 = false;
                    OkioStorage.Companion.getActiveFiles$datastore_core_okio().remove(OkioStorage.access$getCanonicalPath(okioStorage).toString());
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
    }

    public static final /* synthetic */ Path access$getCanonicalPath(OkioStorage $this) {
        return $this.getCanonicalPath();
    }

    public static final /* synthetic */ Function0 access$getProducePath$p(OkioStorage $this) {
        return $this.producePath;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/datastore/core/okio/OkioStorage$Companion;", "", "()V", "activeFiles", "", "", "getActiveFiles$datastore_core_okio", "()Ljava/util/Set;", "activeFilesLock", "Landroidx/datastore/core/okio/Synchronizer;", "getActiveFilesLock", "()Landroidx/datastore/core/okio/Synchronizer;", "datastore-core-okio"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getActiveFiles$datastore_core_okio() {
            return activeFiles;
        }

        @NotNull
        public final Synchronizer getActiveFilesLock() {
            return activeFilesLock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

