/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.security.MessageDigest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.KotlinExtensionsKt;
import org.http4k.core.Body;
import org.http4k.core.ContentType;
import org.http4k.core.Filter;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.HttpTransaction;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.filter.CompressionResult;
import org.http4k.filter.GzipCompressionMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ7\u0010\n\u001a\u00020\u00052*\u0010\u000b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\f\"\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\f\"\u00020\b\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00052\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\f\"\u00020\b\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/http4k/filter/ResponseFilters;", "", "<init>", "()V", "Base64EncodeBody", "Lorg/http4k/core/Filter;", "SetHeader", "name", "", "value", "Modify", "modifiers", "", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "([Lkotlin/jvm/functions/Function1;)Lorg/http4k/core/Filter;", "IncludeHeaders", "headerNames", "([Ljava/lang/String;)Lorg/http4k/core/Filter;", "ExcludeHeaders", "Tap", "ReportHttpTransaction", "ReportRouteLatency", "GZipContentTypes", "GZip", "GunZip", "EtagSupport", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nResponseFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n774#3:253\n865#3,2:254\n774#3:256\n865#3,2:257\n*S KotlinDebug\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters\n*L\n232#1:253\n232#1:254,2\n243#1:256\n243#1:257,2\n*E\n"})
public final class ResponseFilters {
    @NotNull
    public static final ResponseFilters INSTANCE = new ResponseFilters();

    private ResponseFilters() {
    }

    @NotNull
    public final Filter Base64EncodeBody() {
        return ResponseFilters::Base64EncodeBody$lambda$0;
    }

    @NotNull
    public final Filter SetHeader(@NotNull String name, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return arg_0 -> ResponseFilters.SetHeader$lambda$0(name, value2, arg_0);
    }

    @NotNull
    public final Filter Modify(Function1<? super Response, ? extends Response> ... modifiers) {
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        return arg_0 -> ResponseFilters.Modify$lambda$0(modifiers, arg_0);
    }

    @NotNull
    public final Filter IncludeHeaders(String ... headerNames) {
        Intrinsics.checkNotNullParameter((Object)headerNames, (String)"headerNames");
        return arg_0 -> ResponseFilters.IncludeHeaders$lambda$0(headerNames, arg_0);
    }

    @NotNull
    public final Filter ExcludeHeaders(String ... headerNames) {
        Intrinsics.checkNotNullParameter((Object)headerNames, (String)"headerNames");
        return arg_0 -> ResponseFilters.ExcludeHeaders$lambda$0(headerNames, arg_0);
    }

    private static final Function1 Base64EncodeBody$lambda$0(Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> ResponseFilters.Base64EncodeBody$lambda$0$0(next, arg_0);
    }

    private static final Response Base64EncodeBody$lambda$0$0(Function1 $next, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Response $this$Base64EncodeBody_u24lambda_u240_u240_u240 = (Response)$next.invoke((Object)it);
        boolean bl = false;
        return $this$Base64EncodeBody_u24lambda_u240_u240_u240.body(KotlinExtensionsKt.base64Encode($this$Base64EncodeBody_u24lambda_u240_u240_u240.getBody().getPayload()));
    }

    private static final Function1 SetHeader$lambda$0(String $name, String $value, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> ResponseFilters.SetHeader$lambda$0$0(next, $name, $value, arg_0);
    }

    private static final Response SetHeader$lambda$0$0(Function1 $next, String $name, String $value, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Response)$next.invoke((Object)it)).header($name, $value);
    }

    private static final Function1 Modify$lambda$0(Function1[] $modifiers, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> ResponseFilters.Modify$lambda$0$0(next, $modifiers, arg_0);
    }

    private static final Response Modify$lambda$0$0(Function1 $next, Function1[] $modifiers, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Response)HttpKt.with((HttpMessage)$next.invoke((Object)it), Arrays.copyOf($modifiers, $modifiers.length));
    }

    private static final Function1 IncludeHeaders$lambda$0(String[] $headerNames, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> ResponseFilters.IncludeHeaders$lambda$0$0(next, $headerNames, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Response IncludeHeaders$lambda$0$0(Function1 $next, String[] $headerNames, Request it) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Response response = (Response)$next.invoke((Object)it);
        boolean bl = false;
        Iterable iterable = response.getHeaders();
        Response response2 = response;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            String key = (String)pair.component1();
            if (!ArraysKt.contains((Object[])$headerNames, (Object)key)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return response2.replaceHeaders((List)destination$iv$iv);
    }

    private static final Function1 ExcludeHeaders$lambda$0(String[] $headerNames, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> ResponseFilters.ExcludeHeaders$lambda$0$0(next, $headerNames, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Response ExcludeHeaders$lambda$0$0(Function1 $next, String[] $headerNames, Request it) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Response response = (Response)$next.invoke((Object)it);
        boolean bl = false;
        Iterable iterable = response.getHeaders();
        Response response2 = response;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            String key = (String)pair.component1();
            if (!(!ArraysKt.contains((Object[])$headerNames, (Object)key))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return response2.replaceHeaders((List)destination$iv$iv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JO\u0010\b\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000f2%\u0010\u0010\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000fH\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u0017\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u001e\u0010\u0019\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u001e*\u00020\u001eH\u0002J\f\u0010 \u001a\u00020\u001a*\u00020\u001eH\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/http4k/filter/ResponseFilters$EtagSupport;", "Lorg/http4k/core/Filter;", "<init>", "()V", "md5", "Ljava/lang/ThreadLocal;", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "next", "checkEtag", "response", "closeOldResponse", "", "isStreamingResponse", "", "withSafeHeadersFrom", "sourceResponse", "headerIfPresent", "", "value", "generateStrongEtag", "content", "", "hash", "toHex", "Companion", "http4k-core"})
    @SourceDebugExtension(value={"SMAP\nResponseFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters$EtagSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1803#2,3:252\n*S KotlinDebug\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters$EtagSupport\n*L\n192#1:252,3\n*E\n"})
    public static final class EtagSupport
    implements Filter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final ThreadLocal<MessageDigest> md5 = ThreadLocal.withInitial(EtagSupport::md5$lambda$0);
        @NotNull
        private static final List<String> SAFE_HEADERS;

        @NotNull
        public Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
            Intrinsics.checkNotNullParameter(next, (String)"next");
            return arg_0 -> EtagSupport.invoke$lambda$0(next, this, arg_0);
        }

        private final Response checkEtag(Request request, Response response) {
            Response response2;
            String upstreamEtag = response.header("etag");
            if (upstreamEtag == null && this.isStreamingResponse(response)) {
                response2 = response;
            } else {
                String string = upstreamEtag;
                if (string == null) {
                    byte[] byArray = response.getBody().getPayload().array();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                    string = this.generateStrongEtag(byArray);
                }
                String etag = string;
                if (Intrinsics.areEqual((Object)etag, (Object)request.header("if-none-match"))) {
                    this.closeOldResponse(response);
                    response2 = this.withSafeHeadersFrom(Response.Companion.create$default(Response.Companion, Status.NOT_MODIFIED, null, 2, null), response).header("etag", etag);
                } else {
                    response2 = upstreamEtag == null ? response.header("etag", etag) : response;
                }
            }
            return response2;
        }

        private final void closeOldResponse(Response response) {
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private final boolean isStreamingResponse(Response response) {
            return response.getBody().getLength() == null;
        }

        /*
         * WARNING - void declaration
         */
        private final Response withSafeHeadersFrom(Response $this$withSafeHeadersFrom, Response sourceResponse) {
            void $this$fold$iv;
            Iterable iterable = SAFE_HEADERS;
            Response initial$iv = $this$withSafeHeadersFrom;
            boolean $i$f$fold = false;
            Response accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void headerName;
                String string = (String)element$iv;
                Response response = accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.headerIfPresent(response, (String)headerName, sourceResponse.header((String)headerName));
            }
            return accumulator$iv;
        }

        private final Response headerIfPresent(Response $this$headerIfPresent, String name, String value2) {
            return value2 != null ? $this$headerIfPresent.header(name, value2) : $this$headerIfPresent;
        }

        private final String generateStrongEtag(byte[] content) {
            return "\"" + this.toHex(this.hash(content)) + "\"";
        }

        private final byte[] hash(byte[] $this$hash) {
            byte[] byArray = this.md5.get().digest($this$hash);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return byArray;
        }

        private final String toHex(byte[] $this$toHex) {
            return ArraysKt.joinToString$default((byte[])$this$toHex, (CharSequence)"", null, null, (int)0, null, EtagSupport::toHex$lambda$0, (int)30, null);
        }

        private static final MessageDigest md5$lambda$0() {
            return MessageDigest.getInstance("MD5");
        }

        /*
         * WARNING - void declaration
         */
        private static final Response invoke$lambda$0(Function1 $next, EtagSupport this$0, Request request) {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Response response = (Response)$next.invoke((Object)request);
            boolean bl = false;
            return request.getMethod() == Method.GET && Intrinsics.areEqual((Object)response.getStatus(), (Object)Status.OK) ? this$0.checkEtag(request, response) : var3_3;
        }

        private static final CharSequence toHex$lambda$0(byte it) {
            String string = "%02x";
            Object[] objectArray = new Object[]{it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        static {
            Object[] objectArray = new String[]{"date", "last-modified", "cache-control", "expires", "set-cookie", "vary", "surrogate-key"};
            SAFE_HEADERS = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/http4k/filter/ResponseFilters$EtagSupport$Companion;", "", "<init>", "()V", "SAFE_HEADERS", "", "", "http4k-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/http4k/filter/ResponseFilters$GZip;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "compressionMode", "Lorg/http4k/filter/GzipCompressionMode;", "http4k-core"})
    public static final class GZip {
        @NotNull
        public static final GZip INSTANCE = new GZip();

        private GZip() {
        }

        @NotNull
        public final Filter invoke(@NotNull GzipCompressionMode compressionMode) {
            Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
            return arg_0 -> GZip.invoke$lambda$0(compressionMode, arg_0);
        }

        public static /* synthetic */ Filter invoke$default(GZip gZip, GzipCompressionMode gzipCompressionMode, int n, Object object) {
            if ((n & 1) != 0) {
                gzipCompressionMode = new GzipCompressionMode.Memory(0, 1, null);
            }
            return gZip.invoke(gzipCompressionMode);
        }

        private static final Function1 invoke$lambda$0(GzipCompressionMode $compressionMode, Function1 next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            return arg_0 -> GZip.invoke$lambda$0$0(next, $compressionMode, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        private static final Response invoke$lambda$0$0(Function1 $next, GzipCompressionMode $compressionMode, Request request) {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Response it = (Response)$next.invoke((Object)request);
            boolean bl = false;
            String string = request.header("accept-encoding");
            if (string == null) {
                string = "";
            }
            return StringsKt.contains((CharSequence)string, (CharSequence)"gzip", (boolean)true) ? ((CompressionResult)$compressionMode.getCompress$http4k_core().invoke((Object)it.getBody())).apply(it) : var3_3;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJO\u0010\f\u001a!\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rj\u0002`\u00132%\u0010\u0014\u001a!\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rj\u0002`\u0013H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/filter/ResponseFilters$GZipContentTypes;", "Lorg/http4k/core/Filter;", "compressibleContentTypes", "", "Lorg/http4k/core/ContentType;", "compressionMode", "Lorg/http4k/filter/GzipCompressionMode;", "<init>", "(Ljava/util/Set;Lorg/http4k/filter/GzipCompressionMode;)V", "compressibleMimeTypes", "", "", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "next", "isCompressible", "", "it", "mimeTypeOf", "requestAcceptsGzip", "http4k-core"})
    @SourceDebugExtension(value={"SMAP\nResponseFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters$GZipContentTypes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1563#2:252\n1634#2,3:253\n1563#2:256\n1634#2,3:257\n*S KotlinDebug\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters$GZipContentTypes\n*L\n93#1:252\n93#1:253,3\n94#1:256\n94#1:257,3\n*E\n"})
    public static final class GZipContentTypes
    implements Filter {
        @NotNull
        private final GzipCompressionMode compressionMode;
        @NotNull
        private final List<String> compressibleMimeTypes;

        public GZipContentTypes(@NotNull Set<ContentType> compressibleContentTypes, @NotNull GzipCompressionMode compressionMode) {
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(compressibleContentTypes, (String)"compressibleContentTypes");
            Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
            this.compressionMode = compressionMode;
            Iterable iterable = compressibleContentTypes;
            GZipContentTypes gZipContentTypes = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ContentType contentType = (ContentType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((ContentType)((Object)it)).getValue());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{";"};
                collection.add((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
            }
            gZipContentTypes.compressibleMimeTypes = (List)destination$iv$iv;
        }

        public /* synthetic */ GZipContentTypes(Set set, GzipCompressionMode gzipCompressionMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                gzipCompressionMode = new GzipCompressionMode.Memory(0, 1, null);
            }
            this(set, gzipCompressionMode);
        }

        @NotNull
        public Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
            Intrinsics.checkNotNullParameter(next, (String)"next");
            return arg_0 -> GZipContentTypes.invoke$lambda$0(next, this, arg_0);
        }

        private final boolean isCompressible(Response it) {
            return this.compressibleMimeTypes.contains(this.mimeTypeOf(it));
        }

        private final String mimeTypeOf(Response it) {
            String string = it.header("content-type");
            if (string == null) {
                string = "";
            }
            String[] stringArray = new String[]{";"};
            return ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null))))).toString();
        }

        private final boolean requestAcceptsGzip(Request it) {
            String string = it.header("accept-encoding");
            if (string == null) {
                string = "";
            }
            return StringsKt.contains((CharSequence)string, (CharSequence)"gzip", (boolean)true);
        }

        private static final Response invoke$lambda$0(Function1 $next, GZipContentTypes this$0, Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Response it = (Response)$next.invoke((Object)request);
            boolean bl = false;
            return this$0.requestAcceptsGzip(request) && this$0.isCompressible(it) ? ((CompressionResult)this$0.compressionMode.getCompress$http4k_core().invoke((Object)it.getBody())).apply(it) : it;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/http4k/filter/ResponseFilters$GunZip;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "compressionMode", "Lorg/http4k/filter/GzipCompressionMode;", "http4k-core"})
    @SourceDebugExtension(value={"SMAP\nResponseFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseFilters.kt\norg/http4k/filter/ResponseFilters$GunZip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1#2:252\n*E\n"})
    public static final class GunZip {
        @NotNull
        public static final GunZip INSTANCE = new GunZip();

        private GunZip() {
        }

        @NotNull
        public final Filter invoke(@NotNull GzipCompressionMode compressionMode) {
            Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
            return arg_0 -> GunZip.invoke$lambda$0(compressionMode, arg_0);
        }

        public static /* synthetic */ Filter invoke$default(GunZip gunZip, GzipCompressionMode gzipCompressionMode, int n, Object object) {
            if ((n & 1) != 0) {
                gzipCompressionMode = new GzipCompressionMode.Memory(0, 1, null);
            }
            return gunZip.invoke(gzipCompressionMode);
        }

        private static final Function1 invoke$lambda$0(GzipCompressionMode $compressionMode, Function1 next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            return arg_0 -> GunZip.invoke$lambda$0$0(next, $compressionMode, arg_0);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private static final Response invoke$lambda$0$0(Function1 $next, GzipCompressionMode $compressionMode, Request request) {
            void var3_3;
            Response response;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Response response2 = (Response)$next.invoke((Object)request.header("accept-encoding", "gzip"));
            boolean bl = false;
            String string = response2.header("content-encoding");
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                String string2 = StringsKt.contains$default((CharSequence)it, (CharSequence)"gzip", (boolean)false, (int)2, null) ? it : null;
                if (string2 != null) {
                    String it2 = string2;
                    boolean bl3 = false;
                    Response response3 = response2.body((Body)$compressionMode.getDecompress$http4k_core().invoke((Object)response2.getBody()));
                    if (response3 != null) {
                        response = response3;
                        return response;
                    }
                }
            }
            response = var3_3;
            return response;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tH\u0086\u0002JE\u0010\u0004\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tH\u0086\u0002\u00a8\u0006\u0011"}, d2={"Lorg/http4k/filter/ResponseFilters$ReportHttpTransaction;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "clock", "Ljava/time/Clock;", "transactionLabeler", "Lkotlin/Function1;", "Lorg/http4k/core/HttpTransaction;", "Lorg/http4k/filter/HttpTransactionLabeler;", "recordFn", "", "timeSource", "Lkotlin/Function0;", "Ljava/time/Instant;", "http4k-core"})
    public static final class ReportHttpTransaction {
        @NotNull
        public static final ReportHttpTransaction INSTANCE = new ReportHttpTransaction();

        private ReportHttpTransaction() {
        }

        @NotNull
        public final Filter invoke(@NotNull Clock clock, @NotNull Function1<? super HttpTransaction, HttpTransaction> transactionLabeler, @NotNull Function1<? super HttpTransaction, Unit> recordFn) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Intrinsics.checkNotNullParameter(transactionLabeler, (String)"transactionLabeler");
            Intrinsics.checkNotNullParameter(recordFn, (String)"recordFn");
            return this.invoke((Function0<Instant>)((Function0)new Function0<Instant>((Object)clock){

                public final Instant invoke() {
                    return ((Clock)this.receiver).instant();
                }
            }), transactionLabeler, recordFn);
        }

        public static /* synthetic */ Filter invoke$default(ReportHttpTransaction reportHttpTransaction, Clock clock, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 1) != 0) {
                Clock clock2 = Clock.systemUTC();
                Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
                clock = clock2;
            }
            if ((n & 2) != 0) {
                function1 = ReportHttpTransaction::invoke$lambda$0;
            }
            return reportHttpTransaction.invoke(clock, (Function1<? super HttpTransaction, HttpTransaction>)function1, (Function1<? super HttpTransaction, Unit>)function12);
        }

        @NotNull
        public final Filter invoke(@NotNull Function0<Instant> timeSource, @NotNull Function1<? super HttpTransaction, HttpTransaction> transactionLabeler, @NotNull Function1<? super HttpTransaction, Unit> recordFn) {
            Intrinsics.checkNotNullParameter(timeSource, (String)"timeSource");
            Intrinsics.checkNotNullParameter(transactionLabeler, (String)"transactionLabeler");
            Intrinsics.checkNotNullParameter(recordFn, (String)"recordFn");
            return arg_0 -> ReportHttpTransaction.invoke$lambda$2(timeSource, recordFn, transactionLabeler, arg_0);
        }

        public static /* synthetic */ Filter invoke$default(ReportHttpTransaction reportHttpTransaction, Function0 function0, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = ReportHttpTransaction::invoke$lambda$1;
            }
            return reportHttpTransaction.invoke((Function0<Instant>)function0, (Function1<? super HttpTransaction, HttpTransaction>)function1, (Function1<? super HttpTransaction, Unit>)function12);
        }

        private static final HttpTransaction invoke$lambda$0(HttpTransaction it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        private static final HttpTransaction invoke$lambda$1(HttpTransaction it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        private static final Function1 invoke$lambda$2(Function0 $timeSource, Function1 $recordFn, Function1 $transactionLabeler, Function1 next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            return arg_0 -> ReportHttpTransaction.invoke$lambda$2$0($timeSource, next, $recordFn, $transactionLabeler, arg_0);
        }

        private static final Response invoke$lambda$2$0(Function0 $timeSource, Function1 $next, Function1 $recordFn, Function1 $transactionLabeler, Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Instant start = (Instant)$timeSource.invoke();
            boolean bl = false;
            Object object = $next.invoke((Object)request);
            Response $this$invoke_u24lambda_u242_u240_u240_u240 = (Response)object;
            boolean bl2 = false;
            Duration duration2 = Duration.between(start, (Temporal)$timeSource.invoke());
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"between(...)");
            Duration duration3 = duration2;
            $recordFn.invoke($transactionLabeler.invoke((Object)new HttpTransaction(request, $this$invoke_u24lambda_u242_u240_u240_u240, duration3, null, start, 8, null)));
            return (Response)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tH\u0086\u0002J1\u0010\u0004\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tH\u0086\u0002\u00a8\u0006\u0010"}, d2={"Lorg/http4k/filter/ResponseFilters$ReportRouteLatency;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "clock", "Ljava/time/Clock;", "recordFn", "Lkotlin/Function2;", "", "Ljava/time/Duration;", "", "timeSource", "Lkotlin/Function0;", "Ljava/time/Instant;", "http4k-core"})
    public static final class ReportRouteLatency {
        @NotNull
        public static final ReportRouteLatency INSTANCE = new ReportRouteLatency();

        private ReportRouteLatency() {
        }

        @NotNull
        public final Filter invoke(@NotNull Clock clock, @NotNull Function2<? super String, ? super Duration, Unit> recordFn) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Intrinsics.checkNotNullParameter(recordFn, (String)"recordFn");
            return this.invoke((Function0<Instant>)((Function0)new Function0<Instant>((Object)clock){

                public final Instant invoke() {
                    return ((Clock)this.receiver).instant();
                }
            }), recordFn);
        }

        public static /* synthetic */ Filter invoke$default(ReportRouteLatency reportRouteLatency, Clock clock, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                Clock clock2 = Clock.systemUTC();
                Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
                clock = clock2;
            }
            return reportRouteLatency.invoke(clock, (Function2<? super String, ? super Duration, Unit>)function2);
        }

        @NotNull
        public final Filter invoke(@NotNull Function0<Instant> timeSource, @NotNull Function2<? super String, ? super Duration, Unit> recordFn) {
            Intrinsics.checkNotNullParameter(timeSource, (String)"timeSource");
            Intrinsics.checkNotNullParameter(recordFn, (String)"recordFn");
            return ReportHttpTransaction.invoke$default(ReportHttpTransaction.INSTANCE, timeSource, null, arg_0 -> ReportRouteLatency.invoke$lambda$0(recordFn, arg_0), 2, null);
        }

        private static final Unit invoke$lambda$0(Function2 $recordFn, HttpTransaction tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            $recordFn.invoke((Object)(tx.getRequest().getMethod() + "." + StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)tx.getRoutingGroup(), (char)'.', (char)'_', (boolean)false, (int)4, null), (char)':', (char)'.', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null) + "." + tx.getResponse().getStatus().getCode() / 100 + "xx." + tx.getResponse().getStatus().getCode()), (Object)tx.getDuration());
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/http4k/filter/ResponseFilters$Tap;", "", "<init>", "()V", "invoke", "Lorg/http4k/core/Filter;", "fn", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "", "http4k-core"})
    public static final class Tap {
        @NotNull
        public static final Tap INSTANCE = new Tap();

        private Tap() {
        }

        @NotNull
        public final Filter invoke(@NotNull Function1<? super Response, Unit> fn) {
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            return arg_0 -> Tap.invoke$lambda$0(fn, arg_0);
        }

        private static final Function1 invoke$lambda$0(Function1 $fn, Function1 next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            return arg_0 -> Tap.invoke$lambda$0$0(next, $fn, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        private static final Response invoke$lambda$0$0(Function1 $next, Function1 $fn, Request it) {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Response it2 = (Response)$next.invoke((Object)it);
            boolean bl = false;
            $fn.invoke((Object)it2);
            return var3_3;
        }
    }
}

