/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.core.Body;
import org.http4k.core.ContentType;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.MimeTypes;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.lens.Header;
import org.http4k.routing.ResourceLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007B+\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0011\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/http4k/routing/ResourceLoadingHandler;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "pathSegments", "", "resourceLoader", "Lorg/http4k/routing/ResourceLoader;", "extraFileExtensionToContentTypes", "", "Lorg/http4k/core/ContentType;", "<init>", "(Ljava/lang/String;Lorg/http4k/routing/ResourceLoader;Ljava/util/Map;)V", "extMap", "Lorg/http4k/core/MimeTypes;", "invoke", "p1", "load", "path", "loadPath", "pathWithIndex", "convertPath", "isStartingWithPathSegment", "", "http4k-core"})
public final class ResourceLoadingHandler
implements Function1<Request, Response> {
    @NotNull
    private final String pathSegments;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final MimeTypes extMap;

    public ResourceLoadingHandler(@NotNull String pathSegments, @NotNull ResourceLoader resourceLoader, @NotNull Map<String, ContentType> extraFileExtensionToContentTypes) {
        Intrinsics.checkNotNullParameter((Object)pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter(extraFileExtensionToContentTypes, (String)"extraFileExtensionToContentTypes");
        this.pathSegments = pathSegments;
        this.resourceLoader = resourceLoader;
        this.extMap = MimeTypes.Companion.invoke(extraFileExtensionToContentTypes);
    }

    @NotNull
    public Response invoke(@NotNull Request p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.isStartingWithPathSegment(p1) && p1.getMethod() == Method.GET ? this.load(this.convertPath(p1.getUri().getPath())) : Response.Companion.create$default(Response.Companion, Status.NOT_FOUND, null, 2, null);
    }

    private final Response load(String path) {
        Response response = this.loadPath(path);
        if (response == null && (response = this.loadPath(this.pathWithIndex(path))) == null) {
            response = Response.Companion.create$default(Response.Companion, Status.NOT_FOUND, null, 2, null);
        }
        return response;
    }

    private final Response loadPath(String path) {
        Response response;
        URL uRL = this.resourceLoader.load(path);
        if (uRL != null) {
            URL url2 = uRL;
            boolean bl = false;
            ContentType lookupType = this.extMap.forFile(path);
            if (!Intrinsics.areEqual((Object)lookupType, (Object)ContentType.Companion.getOCTET_STREAM())) {
                Function1[] function1Array = new Function1[]{Header.INSTANCE.getCONTENT_TYPE().of(lookupType)};
                Response response2 = (Response)HttpKt.with((HttpMessage)Response.Companion.create$default(Response.Companion, Status.OK, null, 2, null), function1Array);
                InputStream inputStream = url2.openStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
                response = response2.body(Body.Companion.create$default(Body.Companion, inputStream, null, 2, null));
            } else {
                response = null;
            }
        } else {
            response = null;
        }
        return response;
    }

    private final String pathWithIndex(String path) {
        String newPath = StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? path + "index.html" : path + "/index.html";
        char[] cArray = new char[]{'/'};
        return StringsKt.trimStart((String)newPath, (char[])cArray);
    }

    private final String convertPath(String path) {
        String newPath = Intrinsics.areEqual((Object)this.pathSegments, (Object)"/") || Intrinsics.areEqual((Object)this.pathSegments, (Object)"") ? path : StringsKt.replaceFirst$default((String)path, (String)this.pathSegments, (String)"", (boolean)false, (int)4, null);
        String resolved = Intrinsics.areEqual((Object)newPath, (Object)"/") || StringsKt.isBlank((CharSequence)newPath) ? "/index.html" : newPath;
        char[] cArray = new char[]{'/'};
        return StringsKt.trimStart((String)resolved, (char[])cArray);
    }

    private final boolean isStartingWithPathSegment(Request p1) {
        return StringsKt.startsWith$default((String)p1.getUri().getPath(), (String)this.pathSegments, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)p1.getUri().getPath(), (String)("/" + this.pathSegments), (boolean)false, (int)2, null);
    }
}

