/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.core.AcceptKt;
import org.http4k.core.Body;
import org.http4k.core.ContentType;
import org.http4k.core.Method;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.routing.Matcher;
import org.http4k.routing.Router;
import org.http4k.routing.RouterKt;
import org.http4k.routing.RoutingHttpHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0003*\u00020\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\"\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u001a\u001f\u0010\r\u001a\u00020\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000f\"\u00020\b\u00a2\u0006\u0002\u0010\u0010\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u001a\u001f\u0010\u0015\u001a\u00020\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000f\"\u00020\b\u00a2\u0006\u0002\u0010\u0010\u001a\u001a\u0010\u0016\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b0\n\u001a!\u0010\u0016\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\b\u0018\u001a\u0015\u0010\u0000\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0004\u001a\u0015\u0010\u0019\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0004\u00a8\u0006\u001c"}, d2={"and", "Lorg/http4k/routing/RoutingHttpHandler;", "router", "Lorg/http4k/routing/Router;", "asRouter", "Lorg/http4k/core/Method;", "query", "name", "", "fn", "Lkotlin/Function1;", "", "value", "queries", "names", "", "([Ljava/lang/String;)Lorg/http4k/routing/Router;", "queriesFrom", "uri", "Lorg/http4k/core/Uri;", "header", "headers", "body", "Lorg/http4k/core/Body;", "bodyMatches", "accepting", "contentType", "Lorg/http4k/core/ContentType;", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nrouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 routing.kt\norg/http4k/routing/RoutingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n1761#2,3:94\n1740#2,3:99\n1761#2,3:102\n12767#3,2:97\n12767#3,2:105\n*S KotlinDebug\n*F\n+ 1 routing.kt\norg/http4k/routing/RoutingKt\n*L\n22#1:94,3\n45#1:99,3\n51#1:102,3\n33#1:97,2\n62#1:105,2\n*E\n"})
public final class RoutingKt {
    @NotNull
    public static final RoutingHttpHandler and(@NotNull RoutingHttpHandler $this$and, @NotNull Router router) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        return (RoutingHttpHandler)$this$and.withRouter(router);
    }

    @NotNull
    public static final Router asRouter(@NotNull Method $this$asRouter) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$asRouter), (String)"<this>");
        return Router.Companion.invoke("method == " + $this$asRouter, Status.METHOD_NOT_ALLOWED, (Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.asRouter$lambda$0($this$asRouter, arg_0)));
    }

    @NotNull
    public static final Router and(@NotNull Method $this$and, @NotNull Router router) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$and), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        return RouterKt.and(RoutingKt.asRouter($this$and), router);
    }

    @NotNull
    public static final Router query(@NotNull String name, @NotNull Function1<? super String, Boolean> fn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        return RouterKt.asRouter((Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.query$lambda$0(name, fn, arg_0)), "Query " + name + " matching " + fn);
    }

    @NotNull
    public static final Router query(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return RoutingKt.query(name, (Function1<? super String, Boolean>)((Function1)Matcher.Companion.equalTo(value2)));
    }

    @NotNull
    public static final Router queries(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return RouterKt.asRouter((Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.queries$lambda$0(names, arg_0)), "Queries " + ArraysKt.toList((Object[])names));
    }

    @NotNull
    public static final Router query(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RouterKt.asRouter$default(arg_0 -> RoutingKt.query$lambda$1(name, arg_0), null, 1, null);
    }

    @NotNull
    public static final Router queriesFrom(@NotNull Uri uri2) {
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return RouterKt.asRouter$default(arg_0 -> RoutingKt.queriesFrom$lambda$0(uri2, arg_0), null, 1, null);
    }

    @NotNull
    public static final Router header(@NotNull String name, @NotNull Function1<? super String, Boolean> fn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        return RouterKt.asRouter((Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.header$lambda$0(name, fn, arg_0)), "Header " + name + " matching " + fn);
    }

    @NotNull
    public static final Router header(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return RoutingKt.header(name, (Function1<? super String, Boolean>)((Function1)Matcher.Companion.equalTo(value2)));
    }

    @NotNull
    public static final Router headers(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return RouterKt.asRouter((Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.headers$lambda$0(names, arg_0)), "Headers " + ArraysKt.toList((Object[])names));
    }

    @NotNull
    public static final Router body(@NotNull Function1<? super Body, Boolean> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        return RouterKt.asRouter((Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.body$lambda$0(fn, arg_0)), "Body matching " + fn);
    }

    @JvmName(name="bodyMatches")
    @NotNull
    public static final Router bodyMatches(@NotNull Function1<? super String, Boolean> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        return RouterKt.asRouter((Function1<? super Request, Boolean>)((Function1)arg_0 -> RoutingKt.body$lambda$1(fn, arg_0)), "Body matching " + fn);
    }

    @NotNull
    public static final Router and(@NotNull String $this$and, @NotNull Router router) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        return RouterKt.and(RouterKt.asRouter$default(arg_0 -> RoutingKt.and$lambda$0($this$and, arg_0), null, 1, null), router);
    }

    @NotNull
    public static final Router accepting(@NotNull String $this$accepting, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$accepting, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return RoutingKt.and($this$accepting, AcceptKt.accepted(contentType));
    }

    private static final boolean asRouter$lambda$0(Method $this_asRouter, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMethod() == $this_asRouter;
    }

    private static final boolean query$lambda$0(String $name, Function1 $fn, Request req) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            Iterable $this$any$iv = CollectionsKt.filterNotNull((Iterable)req.queries($name));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    if (!((Boolean)$fn.invoke(element$iv)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean queries$lambda$0(String[] $names, Request req) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            String[] $this$all$iv = $names;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (req.query(it) != null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean query$lambda$1(String $name, Request req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        return !((Collection)req.queries($name)).isEmpty();
    }

    private static final boolean queriesFrom$lambda$0(Uri $uri, Request req) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            Iterable $this$all$iv = ParametersKt.queries($uri);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    String name = (String)pair.component1();
                    String value2 = (String)pair.component2();
                    if (req.queries(name).contains(value2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean header$lambda$0(String $name, Function1 $fn, Request req) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            Iterable $this$any$iv = CollectionsKt.filterNotNull((Iterable)req.headerValues($name));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    if (!((Boolean)$fn.invoke(element$iv)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean headers$lambda$0(String[] $names, Request req) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            String[] $this$all$iv = $names;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (req.header(it) != null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean body$lambda$0(Function1 $fn, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$fn.invoke((Object)it.getBody());
    }

    private static final boolean body$lambda$1(Function1 $fn, Request req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        return (Boolean)$fn.invoke((Object)req.bodyString());
    }

    private static final boolean and$lambda$0(String $this_and, Request req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        char[] cArray = new char[]{'/'};
        String string = StringsKt.trim((String)req.getUri().getPath(), (char[])cArray);
        cArray = new char[]{'/'};
        return Intrinsics.areEqual((Object)string, (Object)StringsKt.trim((String)$this_and, (char[])cArray));
    }
}

