/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.AlternativeRendition;
import io.lindstrom.m3u8.model.Channels;
import io.lindstrom.m3u8.model.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class AlternativeRenditionBuilder {
    private static final long INIT_BIT_TYPE = 1L;
    private static final long INIT_BIT_GROUP_ID = 2L;
    private static final long INIT_BIT_NAME = 4L;
    private long initBits = 7L;
    private MediaType type;
    private String uri;
    private String groupId;
    private String language;
    private String assocLanguage;
    private String name;
    private String stableRenditionId;
    private Boolean defaultRendition;
    private Boolean autoSelect;
    private Boolean forced;
    private String inStreamId;
    private List<String> characteristics = new ArrayList<String>();
    private Channels channels;

    AlternativeRenditionBuilder() {
        if (!(this instanceof AlternativeRendition.Builder)) {
            throw new UnsupportedOperationException("Use: new AlternativeRendition.Builder()");
        }
    }

    public final AlternativeRendition.Builder from(AlternativeRendition instance) {
        Optional<String> inStreamIdOptional;
        Optional<Boolean> forcedOptional;
        Optional<Boolean> autoSelectOptional;
        Optional<Boolean> defaultRenditionOptional;
        Optional<String> assocLanguageOptional;
        Objects.requireNonNull(instance, "instance");
        this.type(instance.type());
        Optional<String> uriOptional = instance.uri();
        if (uriOptional.isPresent()) {
            this.uri(uriOptional);
        }
        this.groupId(instance.groupId());
        Optional<String> languageOptional = instance.language();
        if (languageOptional.isPresent()) {
            this.language(languageOptional);
        }
        if ((assocLanguageOptional = instance.assocLanguage()).isPresent()) {
            this.assocLanguage(assocLanguageOptional);
        }
        this.name(instance.name());
        Optional<String> stableRenditionIdOptional = instance.stableRenditionId();
        if (stableRenditionIdOptional.isPresent()) {
            this.stableRenditionId(stableRenditionIdOptional);
        }
        if ((defaultRenditionOptional = instance.defaultRendition()).isPresent()) {
            this.defaultRendition(defaultRenditionOptional);
        }
        if ((autoSelectOptional = instance.autoSelect()).isPresent()) {
            this.autoSelect(autoSelectOptional);
        }
        if ((forcedOptional = instance.forced()).isPresent()) {
            this.forced(forcedOptional);
        }
        if ((inStreamIdOptional = instance.inStreamId()).isPresent()) {
            this.inStreamId(inStreamIdOptional);
        }
        this.addAllCharacteristics(instance.characteristics());
        Optional<Channels> channelsOptional = instance.channels();
        if (channelsOptional.isPresent()) {
            this.channels(channelsOptional);
        }
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder type(MediaType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder uri(Optional<String> uri) {
        this.uri = uri.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder groupId(String groupId) {
        this.groupId = Objects.requireNonNull(groupId, "groupId");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder language(String language) {
        this.language = Objects.requireNonNull(language, "language");
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder language(Optional<String> language) {
        this.language = language.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder assocLanguage(String assocLanguage) {
        this.assocLanguage = Objects.requireNonNull(assocLanguage, "assocLanguage");
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder assocLanguage(Optional<String> assocLanguage) {
        this.assocLanguage = assocLanguage.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder stableRenditionId(String stableRenditionId) {
        this.stableRenditionId = Objects.requireNonNull(stableRenditionId, "stableRenditionId");
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder stableRenditionId(Optional<String> stableRenditionId) {
        this.stableRenditionId = stableRenditionId.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder defaultRendition(boolean defaultRendition) {
        this.defaultRendition = defaultRendition;
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder defaultRendition(Optional<Boolean> defaultRendition) {
        this.defaultRendition = defaultRendition.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder autoSelect(boolean autoSelect) {
        this.autoSelect = autoSelect;
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder autoSelect(Optional<Boolean> autoSelect) {
        this.autoSelect = autoSelect.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder forced(boolean forced) {
        this.forced = forced;
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder forced(Optional<Boolean> forced) {
        this.forced = forced.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder inStreamId(String inStreamId) {
        this.inStreamId = Objects.requireNonNull(inStreamId, "inStreamId");
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder inStreamId(Optional<String> inStreamId) {
        this.inStreamId = inStreamId.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder addCharacteristics(String element) {
        this.characteristics.add(Objects.requireNonNull(element, "characteristics element"));
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder addCharacteristics(String ... elements) {
        for (String element : elements) {
            this.characteristics.add(Objects.requireNonNull(element, "characteristics element"));
        }
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder characteristics(Iterable<String> elements) {
        this.characteristics.clear();
        return this.addAllCharacteristics(elements);
    }

    public final AlternativeRendition.Builder addAllCharacteristics(Iterable<String> elements) {
        for (String element : elements) {
            this.characteristics.add(Objects.requireNonNull(element, "characteristics element"));
        }
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder channels(Channels channels) {
        this.channels = Objects.requireNonNull(channels, "channels");
        return (AlternativeRendition.Builder)this;
    }

    public final AlternativeRendition.Builder channels(Optional<? extends Channels> channels) {
        this.channels = channels.orElse(null);
        return (AlternativeRendition.Builder)this;
    }

    public AlternativeRendition build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableAlternativeRendition(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("type");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("groupId");
        }
        if ((this.initBits & 4L) != 0L) {
            attributes.add("name");
        }
        return "Cannot build AlternativeRendition, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableAlternativeRendition
    implements AlternativeRendition {
        private final MediaType type;
        private final String uri;
        private final String groupId;
        private final String language;
        private final String assocLanguage;
        private final String name;
        private final String stableRenditionId;
        private final Boolean defaultRendition;
        private final Boolean autoSelect;
        private final Boolean forced;
        private final String inStreamId;
        private final List<String> characteristics;
        private final Channels channels;

        private ImmutableAlternativeRendition(AlternativeRenditionBuilder builder) {
            this.type = builder.type;
            this.uri = builder.uri;
            this.groupId = builder.groupId;
            this.language = builder.language;
            this.assocLanguage = builder.assocLanguage;
            this.name = builder.name;
            this.stableRenditionId = builder.stableRenditionId;
            this.defaultRendition = builder.defaultRendition;
            this.autoSelect = builder.autoSelect;
            this.forced = builder.forced;
            this.inStreamId = builder.inStreamId;
            this.characteristics = AlternativeRenditionBuilder.createUnmodifiableList(true, builder.characteristics);
            this.channels = builder.channels;
        }

        @Override
        public MediaType type() {
            return this.type;
        }

        @Override
        public Optional<String> uri() {
            return Optional.ofNullable(this.uri);
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public Optional<String> language() {
            return Optional.ofNullable(this.language);
        }

        @Override
        public Optional<String> assocLanguage() {
            return Optional.ofNullable(this.assocLanguage);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Optional<String> stableRenditionId() {
            return Optional.ofNullable(this.stableRenditionId);
        }

        @Override
        public Optional<Boolean> defaultRendition() {
            return Optional.ofNullable(this.defaultRendition);
        }

        @Override
        public Optional<Boolean> autoSelect() {
            return Optional.ofNullable(this.autoSelect);
        }

        @Override
        public Optional<Boolean> forced() {
            return Optional.ofNullable(this.forced);
        }

        @Override
        public Optional<String> inStreamId() {
            return Optional.ofNullable(this.inStreamId);
        }

        @Override
        public List<String> characteristics() {
            return this.characteristics;
        }

        @Override
        public Optional<Channels> channels() {
            return Optional.ofNullable(this.channels);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableAlternativeRendition && this.equalTo((ImmutableAlternativeRendition)another);
        }

        private boolean equalTo(ImmutableAlternativeRendition another) {
            return this.type.equals((Object)another.type) && Objects.equals(this.uri, another.uri) && this.groupId.equals(another.groupId) && Objects.equals(this.language, another.language) && Objects.equals(this.assocLanguage, another.assocLanguage) && this.name.equals(another.name) && Objects.equals(this.stableRenditionId, another.stableRenditionId) && Objects.equals(this.defaultRendition, another.defaultRendition) && Objects.equals(this.autoSelect, another.autoSelect) && Objects.equals(this.forced, another.forced) && Objects.equals(this.inStreamId, another.inStreamId) && this.characteristics.equals(another.characteristics) && Objects.equals(this.channels, another.channels);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + Objects.hashCode(this.uri);
            h += (h << 5) + this.groupId.hashCode();
            h += (h << 5) + Objects.hashCode(this.language);
            h += (h << 5) + Objects.hashCode(this.assocLanguage);
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + Objects.hashCode(this.stableRenditionId);
            h += (h << 5) + Objects.hashCode(this.defaultRendition);
            h += (h << 5) + Objects.hashCode(this.autoSelect);
            h += (h << 5) + Objects.hashCode(this.forced);
            h += (h << 5) + Objects.hashCode(this.inStreamId);
            h += (h << 5) + this.characteristics.hashCode();
            h += (h << 5) + Objects.hashCode(this.channels);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("AlternativeRendition{");
            builder.append("type=").append((Object)this.type);
            if (this.uri != null) {
                builder.append(", ");
                builder.append("uri=").append(this.uri);
            }
            builder.append(", ");
            builder.append("groupId=").append(this.groupId);
            if (this.language != null) {
                builder.append(", ");
                builder.append("language=").append(this.language);
            }
            if (this.assocLanguage != null) {
                builder.append(", ");
                builder.append("assocLanguage=").append(this.assocLanguage);
            }
            builder.append(", ");
            builder.append("name=").append(this.name);
            if (this.stableRenditionId != null) {
                builder.append(", ");
                builder.append("stableRenditionId=").append(this.stableRenditionId);
            }
            if (this.defaultRendition != null) {
                builder.append(", ");
                builder.append("defaultRendition=").append(this.defaultRendition);
            }
            if (this.autoSelect != null) {
                builder.append(", ");
                builder.append("autoSelect=").append(this.autoSelect);
            }
            if (this.forced != null) {
                builder.append(", ");
                builder.append("forced=").append(this.forced);
            }
            if (this.inStreamId != null) {
                builder.append(", ");
                builder.append("inStreamId=").append(this.inStreamId);
            }
            builder.append(", ");
            builder.append("characteristics=").append(this.characteristics);
            if (this.channels != null) {
                builder.append(", ");
                builder.append("channels=").append(this.channels);
            }
            return builder.append("}").toString();
        }
    }
}

