/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.Resolution;
import io.lindstrom.m3u8.model.VariantBuilder;
import io.lindstrom.m3u8.model.VideoRange;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface Variant {
    public long bandwidth();

    public Optional<Long> averageBandwidth();

    public Optional<Double> score();

    public List<String> codecs();

    public Optional<Resolution> resolution();

    public Optional<Double> frameRate();

    public Optional<String> hdcpLevel();

    public List<String> allowedCpc();

    public Optional<String> stableVariantId();

    public Optional<String> audio();

    public Optional<String> video();

    public Optional<String> subtitles();

    public Optional<String> closedCaptions();

    public Optional<Boolean> closedCaptionsNone();

    public String uri();

    public Optional<Integer> programId();

    public Optional<VideoRange> videoRange();

    public Optional<String> pathwayId();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariantBuilder {
        public Builder resolution(int width, int height) {
            return this.resolution(Resolution.of(width, height));
        }

        public Builder videoRange(String value) {
            return this.videoRange(VideoRange.valueOf(value));
        }
    }
}

