/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.parser.DateRangeAttribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PartialSegmentAttribute;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.SegmentKeyAttribute;
import io.lindstrom.m3u8.parser.SegmentMapAttribute;
import io.lindstrom.m3u8.parser.Tag;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;

enum MediaSegmentTag implements Tag<MediaSegment, MediaSegment.Builder>
{
    EXT_X_DISCONTINUITY{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            builder.discontinuity(true);
        }

        @Override
        public void write(MediaSegment value, TextBuilder textBuilder) {
            if (value.discontinuity()) {
                textBuilder.addTag(this.tag());
            }
        }
    }
    ,
    EXT_X_PROGRAM_DATE_TIME{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            builder.programDateTime(OffsetDateTime.parse(attributes, ParserUtils.FORMATTER));
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.programDateTime().ifPresent(value -> textBuilder.addTag(this.tag(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((TemporalAccessor)value)));
        }
    }
    ,
    EXT_X_GAP{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            builder.gap(true);
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            if (mediaSegment.gap()) {
                textBuilder.addTag(this.tag());
            }
        }
    }
    ,
    EXT_X_DATERANGE{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.dateRange(DateRangeAttribute.parse(attributes, parsingMode));
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.dateRange().ifPresent(value -> textBuilder.addTag(this.tag(), value, DateRangeAttribute.attributeMap));
        }
    }
    ,
    EXT_X_CUE_OUT{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            block2: {
                try {
                    int p = attributes.indexOf(34);
                    String durStr = p < 0 ? (attributes.startsWith("DURATION=") ? attributes.substring(9) : attributes) : attributes.substring(p + 1, attributes.indexOf(34, p + 1));
                    builder.cueOut(Double.parseDouble(durStr));
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    if (parsingMode != ParsingMode.STRICT) break block2;
                    throw e;
                }
            }
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.cueOut().ifPresent(cueOut -> {
                String duration = MediaSegmentTag.durationToString(cueOut);
                textBuilder.add('#').add(this.tag()).add(":").add(duration).add('\n');
            });
        }
    }
    ,
    EXT_X_CUE_IN{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            builder.cueIn(true);
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            if (mediaSegment.cueIn()) {
                textBuilder.addTag(this.tag());
            }
        }
    }
    ,
    EXT_X_BITRATE{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            builder.bitrate(Long.parseLong(attributes));
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.bitrate().ifPresent(v -> textBuilder.addTag(this.tag(), (long)v));
        }
    }
    ,
    EXT_X_MAP{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.segmentMap(SegmentMapAttribute.parse(attributes, parsingMode));
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.segmentMap().ifPresent(value -> textBuilder.addTag(this.tag(), value, SegmentMapAttribute.attributeMap));
        }
    }
    ,
    EXTINF{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) {
            int p = attributes.indexOf(44);
            if (p < 0) {
                builder.duration(Double.parseDouble(attributes));
            } else {
                builder.duration(Double.parseDouble(attributes.substring(0, p)));
                String title = attributes.substring(p + 1);
                if (!title.isEmpty()) {
                    builder.title(title);
                }
            }
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            double d = mediaSegment.duration();
            String duration = MediaSegmentTag.durationToString(d);
            textBuilder.add('#').add(this.tag()).add(":").add(duration).add(",");
            mediaSegment.title().ifPresent(textBuilder::add);
            textBuilder.add('\n');
        }
    }
    ,
    EXT_X_BYTERANGE{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.byteRange(ParserUtils.parseByteRange(attributes));
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.byteRange().ifPresent(value -> textBuilder.addTag(this.tag(), ParserUtils.writeByteRange(value)));
        }
    }
    ,
    EXT_X_KEY{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.addSegmentKeys(SegmentKeyAttribute.parse(attributes, parsingMode));
        }

        @Override
        public void write(MediaSegment mediaSegment, TextBuilder textBuilder) {
            mediaSegment.segmentKeys().forEach(key -> textBuilder.addTag(this.tag(), key, SegmentKeyAttribute.attributeMap));
        }
    }
    ,
    EXT_X_PART{

        @Override
        public void read(MediaSegment.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.addPartialSegments(PartialSegmentAttribute.parse(attributes, parsingMode));
        }

        @Override
        public void write(MediaSegment playlist, TextBuilder textBuilder) {
            playlist.partialSegments().forEach(p -> textBuilder.addTag(this.tag(), p, PartialSegmentAttribute.attributeMap));
        }
    };

    static final Map<String, MediaSegmentTag> tags;

    private static String durationToString(double d) {
        String duration;
        if (d >= 0.001 && d < 1.0E7) {
            duration = Double.toString(d);
        } else {
            DecimalFormat format = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            format.setMaximumFractionDigits(340);
            duration = format.format(d);
        }
        return duration;
    }

    static {
        tags = ParserUtils.toMap(MediaSegmentTag.values(), Tag::tag);
    }
}

