/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.SessionData;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

enum SessionDataAttribute implements Attribute<SessionData, SessionData.Builder>
{
    DATA_ID{

        @Override
        public void read(SessionData.Builder builder, String value) {
            builder.dataId(value);
        }

        @Override
        public void write(SessionData value, TextBuilder textBuilder) {
            textBuilder.addQuoted(this.key(), value.dataId());
        }
    }
    ,
    VALUE{

        @Override
        public void read(SessionData.Builder builder, String value) {
            builder.value(value);
        }

        @Override
        public void write(SessionData value, TextBuilder textBuilder) {
            value.value().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    URI{

        @Override
        public void read(SessionData.Builder builder, String value) {
            builder.uri(value);
        }

        @Override
        public void write(SessionData value, TextBuilder textBuilder) {
            value.uri().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    LANGUAGE{

        @Override
        public void read(SessionData.Builder builder, String value) {
            builder.language(value);
        }

        @Override
        public void write(SessionData value, TextBuilder textBuilder) {
            value.language().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    };

    static final Map<String, SessionDataAttribute> attributeMap;

    static SessionData parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        SessionData.Builder builder = SessionData.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(SessionDataAttribute.values(), Attribute::key);
    }
}

