/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.parser.Attribute;
import java.util.List;
import java.util.Map;

class TextBuilder {
    private final StringBuilder stringBuilder;
    private int currentAttributeCount = 0;

    TextBuilder(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    TextBuilder() {
        this.stringBuilder = new StringBuilder();
    }

    <V, T extends Attribute<V, ?>> void addTag(String tag, List<V> values, Map<String, T> attributeMap) {
        values.forEach(v -> this.addTag(tag, v, attributeMap));
    }

    <V, T extends Attribute<V, ?>> TextBuilder addTag(String tag, V value, Map<String, T> attributeMap) {
        this.stringBuilder.append('#').append(tag).append(':');
        this.currentAttributeCount = 0;
        for (Attribute attribute : attributeMap.values()) {
            attribute.write(value, this);
        }
        this.stringBuilder.append('\n');
        return this;
    }

    public TextBuilder add(String text) {
        this.stringBuilder.append(text);
        return this;
    }

    public TextBuilder add(char ch) {
        this.stringBuilder.append(ch);
        return this;
    }

    public TextBuilder add(double value) {
        this.stringBuilder.append(value);
        return this;
    }

    void addTag(String tag) {
        this.stringBuilder.append('#').append(tag).append('\n');
    }

    void addTag(String tag, int attribute) {
        this.stringBuilder.append('#').append(tag).append(":").append(attribute).append('\n');
    }

    void addTag(String tag, long attribute) {
        this.stringBuilder.append('#').append(tag).append(":").append(attribute).append('\n');
    }

    void addTag(String tag, String attribute) {
        this.stringBuilder.append('#').append(tag).append(":").append(attribute).append('\n');
    }

    public void add(String key, Enum<?> value) {
        this.add(key, value.toString());
    }

    public void add(String key, boolean value) {
        this.add(key, value ? "YES" : "NO");
    }

    public void add(String key, double value) {
        this.add(key, Double.toString(value));
    }

    public void addQuoted(String key, String value) {
        this.add(key, "\"" + value + "\"");
    }

    public void add(String key, String value) {
        if (this.currentAttributeCount > 0) {
            this.stringBuilder.append(",");
        }
        this.stringBuilder.append(key).append("=").append(value);
        ++this.currentAttributeCount;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

