/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.destination;

import ir.amirab.downloader.destination.DestWriter;
import ir.amirab.downloader.destination.DownloadDestination;
import ir.amirab.downloader.part.DownloadPart;
import ir.amirab.downloader.utils.NumUtilKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal._UtilCommonKt;
import okio.FileHandle;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J$\u0010 \u001a\u00020\u001e2\u0014\u0010!\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\u001e0\u0005H\u0096@\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0006J\b\u0010'\u001a\u00020\u001eH\u0016J\u001e\u0010(\u001a\u00020\u001e2\u0014\u0010!\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\u001e0\u0005H\u0016J0\u0010)\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010+\u001a\u00020\u00032\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e0\u0005J\b\u0010-\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lir/amirab/downloader/destination/SegmentedDownloadDestination;", "Lir/amirab/downloader/destination/DownloadDestination;", "tempDirectory", "Ljava/io/File;", "getFileName", "Lkotlin/Function1;", "Lir/amirab/downloader/part/DownloadPart;", "", "getAllParts", "Lkotlin/Function0;", "", "appendMode", "", "outputFile", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;ZLjava/io/File;)V", "getTempDirectory", "()Ljava/io/File;", "getGetFileName", "()Lkotlin/jvm/functions/Function1;", "getGetAllParts", "()Lkotlin/jvm/functions/Function0;", "getAppendMode", "()Z", "getFileOfPart", "downloadPart", "getWriterFor", "Lir/amirab/downloader/destination/DestWriter;", "part", "onPartCancelled", "", "canGetFileWriter", "prepareFile", "onProgressUpdate", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDownloadedPartsIsValid", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDownloadPartValid", "cleanUpJunkFiles", "onAllPartsCompleted", "assemble", "sources", "destination", "onProgress", "flush", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentedDownloadDestination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentedDownloadDestination.kt\nir/amirab/downloader/destination/SegmentedDownloadDestination\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1#2:130\n1056#3:131\n1563#3:132\n1634#3,3:133\n1869#3,2:136\n1869#3,2:138\n*S KotlinDebug\n*F\n+ 1 SegmentedDownloadDestination.kt\nir/amirab/downloader/destination/SegmentedDownloadDestination\n*L\n83#1:131\n84#1:132\n84#1:133,3\n100#1:136,2\n123#1:138,2\n*E\n"})
public final class SegmentedDownloadDestination
extends DownloadDestination {
    @NotNull
    private final File tempDirectory;
    @NotNull
    private final Function1<DownloadPart, String> getFileName;
    @NotNull
    private final Function0<List<DownloadPart>> getAllParts;
    private final boolean appendMode;

    public SegmentedDownloadDestination(@NotNull File tempDirectory, @NotNull Function1<? super DownloadPart, String> getFileName, @NotNull Function0<? extends List<? extends DownloadPart>> getAllParts, boolean appendMode, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
        Intrinsics.checkNotNullParameter(getFileName, (String)"getFileName");
        Intrinsics.checkNotNullParameter(getAllParts, (String)"getAllParts");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        super(outputFile);
        this.tempDirectory = tempDirectory;
        this.getFileName = getFileName;
        this.getAllParts = getAllParts;
        this.appendMode = appendMode;
    }

    @NotNull
    public final File getTempDirectory() {
        return this.tempDirectory;
    }

    @NotNull
    public final Function1<DownloadPart, String> getGetFileName() {
        return this.getFileName;
    }

    @NotNull
    public final Function0<List<DownloadPart>> getGetAllParts() {
        return this.getAllParts;
    }

    public final boolean getAppendMode() {
        return this.appendMode;
    }

    private final File getFileOfPart(DownloadPart downloadPart) {
        long id = downloadPart.getID();
        return FilesKt.resolve((File)this.tempDirectory, (String)String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DestWriter getWriterFor(@NotNull DownloadPart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        this.tempDirectory.mkdirs();
        File tFile = this.getFileOfPart(part);
        FileHandle writer = FileSystem.SYSTEM.openReadWrite(Path.Companion.get$default((Path.Companion)Path.Companion, (File)tFile, (boolean)false, (int)1, null), false, false);
        long newSize = this.appendMode ? writer.size() : 0L;
        writer.resize(newSize);
        DestWriter destWriter = new DestWriter(part.getID(), tFile, newSize, writer);
        SegmentedDownloadDestination segmentedDownloadDestination = this;
        synchronized (segmentedDownloadDestination) {
            boolean bl = false;
            boolean bl2 = this.getFileParts().add(destWriter);
        }
        return destWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPartCancelled(@NotNull DownloadPart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        super.onPartCancelled(part);
        long id = part.getID();
        SegmentedDownloadDestination segmentedDownloadDestination = this;
        synchronized (segmentedDownloadDestination) {
            Unit unit;
            FileHandle fileHandle;
            Object v0;
            block6: {
                boolean bl = false;
                Iterable iterable = this.getFileParts();
                for (Object t : iterable) {
                    DestWriter it = (DestWriter)t;
                    boolean bl2 = false;
                    if (!(it.getId() == id)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            DestWriter destWriter = v0;
            if (destWriter != null && (fileHandle = destWriter.getWriter()) != null) {
                _UtilCommonKt.closeQuietly((Closeable)((Closeable)fileHandle));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    @Override
    public boolean canGetFileWriter() {
        return true;
    }

    @Override
    @Nullable
    public Object prepareFile(@NotNull Function1<? super Integer, Unit> onProgressUpdate, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object isDownloadedPartsIsValid(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)this.tempDirectory.exists());
    }

    public final boolean isDownloadPartValid(@NotNull DownloadPart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        return this.getFileOfPart(part).exists();
    }

    @Override
    public void cleanUpJunkFiles() {
        SegmentedDownloadDestination segmentedDownloadDestination = this;
        try {
            SegmentedDownloadDestination $this$cleanUpJunkFiles_u24lambda_u240 = segmentedDownloadDestination;
            boolean bl = false;
            FileSystem.SYSTEM.deleteRecursively(Path.Companion.get$default((Path.Companion)Path.Companion, (File)$this$cleanUpJunkFiles_u24lambda_u240.tempDirectory, (boolean)false, (int)1, null));
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAllPartsCompleted(@NotNull Function1<? super Integer, Unit> onProgressUpdate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(onProgressUpdate, (String)"onProgressUpdate");
        Iterable $this$sortedBy$iv = (Iterable)this.getAllParts.invoke();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DownloadPart it = (DownloadPart)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getID());
                it = (DownloadPart)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getID()));
            }
        });
        SegmentedDownloadDestination segmentedDownloadDestination = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DownloadPart downloadPart = (DownloadPart)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FilesKt.resolve((File)this.tempDirectory, (String)((String)this.getFileName.invoke((Object)it))));
        }
        File file = this.getOutputFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"<get-outputFile>(...)");
        segmentedDownloadDestination.assemble((List)destination$iv$iv, file, onProgressUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void assemble(@NotNull List<? extends File> sources, @NotNull File destination, @NotNull Function1<? super Integer, Unit> onProgress) {
        File file;
        Object object2;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(onProgress, (String)"onProgress");
        Iterable iterable = sources;
        long l = 0L;
        for (Object object2 : iterable) {
            void it;
            file = (File)object2;
            long l2 = l;
            boolean bl = false;
            long l3 = it.length();
            l = l2 + l3;
        }
        long totalLength = l;
        long totalWritten = 0L;
        byte[] buffer = new byte[8192];
        int percent = 0;
        Closeable closeable = new FileOutputStream(destination);
        object2 = null;
        try {
            FileOutputStream dst = (FileOutputStream)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = sources;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File sourceFile = (File)element$iv;
                boolean bl2 = false;
                Closeable closeable2 = new FileInputStream(sourceFile);
                Throwable throwable = null;
                try {
                    int len;
                    FileInputStream src = (FileInputStream)closeable2;
                    boolean bl3 = false;
                    onProgress.invoke((Object)percent);
                    while ((len = src.read(buffer)) != -1) {
                        dst.write(buffer, 0, len);
                        int newPercent = NumUtilKt.calcPercent(totalWritten += (long)len, totalLength);
                        if (newPercent == percent) continue;
                        onProgress.invoke((Object)newPercent);
                        percent = newPercent;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
            }
            file = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, object2);
        }
        onProgress.invoke((Object)100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        SegmentedDownloadDestination segmentedDownloadDestination = this;
        synchronized (segmentedDownloadDestination) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.getFileParts();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DestWriter it = (DestWriter)element$iv;
                boolean bl2 = false;
                it.getWriter().flush();
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

